#ifndef __BASEOBJECT_H__
#define __BASEOBJECT_H__

#include "Utils.h"
#include <time.h>

enum IDObject
{
	I = 1,
	L = 2,
	J = 3,
	O = 4,
	Z = 5,
	N = 6,
	T = 7,
};

enum STATUS
{
	MOVE,
	STOP,
	COLLIDE,
};

class BaseObject
{
protected:
	IDObject m_ID;
	
	int m_Rotate;

	clock_t begin_time;
	clock_t end_time;

public:
	GPoint2D m_Position;
	STATUS m_Status;
	GRectangle *m_Rectangle;
	GDirections m_Collide;
	bool canDown;

	BaseObject();
	BaseObject(IDObject id);
	~BaseObject();
	virtual void Init();
	virtual void Update();
	virtual void Draw() = 0;
	IDObject getID();
};

#endif